//================================================\\
//| Author: IAMME (C)                            |\\
//| Title: Nano Wallet                           |\\
//| Function: Can store and give credit chits.   |\\
//================================================\\

class GreenWallet extends NanoWallets config(MSMTL);

var() globalconfig int WalletSlot;
var() config string WalletColor;
var bool bNegMode;

function Fire( float Value )
{
       local DeusExPlayer P;

  P = DeusExPlayer(Owner);

 if (HasBank() <= 0)
  P.ClientMessage(""$WalletColor$"You currently have |p4"$P.Credits$" dollars on hand.");
 if (HasBank() >= 1)
  P.ClientMessage(""$WalletColor$"You currently have |p4"$P.Credits$" dollars on hand"$WalletColor$" and |p4"$GetBank().GetAccountBalance(GetOwnerIP() )$" in your bank account.");
}

function string GetOwnerIP()
{
 	local string OwnersIP;

	OwnersIP = PlayerPawn(Owner).GetPlayerNetworkAddress();
	OwnersIP = Left(OwnersIP, InStr(OwnersIP, ":"));
	
	return OwnersIP;
}

//Shouldn't be called unless you've already confirmed a mutator exists, otherwards it
//may create log errors.
function MSBankingMutator GetBank()
{
 local MSBankingMutator Bank, B;
 
 forEach AllActors(class'MSBankingMutator', Bank)
 {
  if (Bank != None)
  {
   B = Bank;
   break;
  }
 }
 
 return B;
}

function int HasBank()
{
 local MSBankingMutator Bank;
 local int i;
 
 forEach AllActors(class'MSBankingMutator', Bank)
 {
  	if (Bank != None)
	 i++;
 }
 
 return i;
}

auto state Pickup
{
	function Frob(Actor Frobber, Inventory frobWith)
	{
		local DeusExPlayer player;

		Super.Frob(Frobber, frobWith);

		player = DeusExPlayer(Frobber);

		if (player != None)
		{
			if (bdrained == 0)
                        {
			player.Credits += CashAmount;
			player.ClientMessage(Sprintf(msgCreditsAdded, CashAmount));
			player.FrobTarget = None;
			bDrained = 1;
                        }
			else if (bdrained == 1)
			{
			player.FrobTarget = None;
			}
		}
	}
}

function ScopeToggle()
{
         local DeusExPlayer P;

  P = DeusExPlayer(Owner);
  if (XMode == 0)
  {
    XMode = 1;
    P.ClientMessage(""$WalletColor$"Nanites Set to 5$, "$P.Credits$" on hand.");
    return;
  }
  if (XMode == 1)
  {
      XMode = 2;
      P.ClientMessage(""$WalletColor$"Nanites set to 10$, "$P.Credits$" on hand.");
      return;
  }
  if (XMode == 2)
  {
    XMode = 3;
    P.ClientMessage(""$WalletColor$"Nanites set to 100$, "$P.Credits$" on hand.");
    return;
  }
  if (XMode == 3)
  {
    XMode = 0;
    P.ClientMessage(""$WalletColor$"Nanites set to 1$, "$P.Credits$" on hand.");
    return;
  }
}

function LaserToggle()
{
       local DeusExPlayer P;

  if (XMode == 0)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 1)
    {
    Spawn(class'NanoDollar2',,,P.Location);
    P.Credits += -1;
    P.ClientMessage(""$WalletColor$"1 Dollar dropped, "$P.Credits$" remaining.");
    }
  else if (P.Credits < 1)
   {
    P.ClientMessage("|p2Insufficient Cash.");
   }
  }
  if (XMode == 1)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 5)
    {
    Spawn(class'NanoFiveDollars2',,,P.Location);
    P.Credits += -5;
    P.ClientMessage(""$WalletColor$"5 Dollars dropped, "$P.Credits$" remaining.");
    }
  else if (P.Credits < 5)
   {
    P.ClientMessage("|p2Insufficient Cash.");
   }
  }
  if (XMode == 2)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 10)
    {
    Spawn(class'NanoTenDollars2',,,P.Location);
    P.Credits += -10;
    P.ClientMessage(""$WalletColor$"10 Dollars dropped, "$P.Credits$" remaining.");
    }
  else if (P.Credits < 10)
   {
    P.ClientMessage("|p2Insufficient Cash.");
   }
  }
  if (XMode == 3)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 100)
    {
    Spawn(class'NanoOneHundredDollars2',,,P.Location);
    P.Credits += -100;
    P.ClientMessage(""$WalletColor$"100 Dollars dropped, "$P.Credits$" remaining.");
    }
  else if (P.Credits < 100)
   {
    P.ClientMessage("|p2Insufficient Cash.");
   }
  }
}

function CycleAmmo()
{
       local DeusExPlayer P;

	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;

	local string FrobbersIP;

	FrobbersIP = PlayerPawn(Owner).GetPlayerNetworkAddress();
	FrobbersIP = Left(FrobbersIP, InStr(FrobbersIP, ":"));

	position    = DeusExPlayer(Owner).Location;
	position.Z += DeusExPlayer(Owner).BaseEyeHeight;
	line        = Vector(DeusExPlayer(Owner).ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);



if(hitActor.IsA('DeusExPlayer'))
{
  if (XMode == 0)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 1)
    {
    P.Credits -= 1;
    DeusExPlayer(hitActor).Credits += 1;
    P.ClientMessage("|p41 Dollar Paid To"$DeusExPlayer(hitActor).PlayerReplicationInfo.PlayerName$", "$WalletColor$""$P.Credits$" remaining.");
    DeusExPlayer(hitActor).ClientMessage("|p4You have just recieved a payment of 1 dollar from "$DeusExPlayer(Owner).PlayerReplicationInfo.PlayerName$"!");
    }
  else if (P.Credits < 1)
   {
    P.ClientMessage("|p2Insufficient Cash.");
   }
  }
  if (XMode == 1)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 5)
    {
    P.Credits -= 5;
    DeusExPlayer(hitActor).Credits += 5;
    P.ClientMessage("|p45 Dollars Paid To "$DeusExPlayer(hitActor).PlayerReplicationInfo.PlayerName$", "$WalletColor$""$P.Credits$" remaining.");
    DeusExPlayer(hitActor).ClientMessage("|p4You have just recieved a payment of 5 dollars from "$DeusExPlayer(Owner).PlayerReplicationInfo.PlayerName$"!");
    }
  else if (P.Credits < 5)
   {
    P.ClientMessage("|p2Insufficient Cash.");
   }
  }
  if (XMode == 2)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 10)
    {
    P.Credits -= 10;
    DeusExPlayer(hitActor).Credits += 10;
    P.ClientMessage("|p410 Dollar Paid To "$DeusExPlayer(hitActor).PlayerReplicationInfo.PlayerName$", "$WalletColor$""$P.Credits$" remaining.");
    DeusExPlayer(hitActor).ClientMessage("|p4You have just recieved a payment of 10 dollars from "$DeusExPlayer(Owner).PlayerReplicationInfo.PlayerName$"!");
    }
  else if (P.Credits < 10)
   {
    P.ClientMessage("|p2Insufficient Cash.");
   }
  }
  if (XMode == 3)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 100)
    {
    P.Credits -= 100;
    DeusExPlayer(hitActor).Credits += 100;
    P.ClientMessage("|p4100 Dollar Paid To"$DeusExPlayer(hitActor).PlayerReplicationInfo.PlayerName$", "$WalletColor$""$P.Credits$" remaining.");
    DeusExPlayer(hitActor).ClientMessage("|p4You have just recieved a payment of 100 dollars from "$DeusExPlayer(Owner).PlayerReplicationInfo.PlayerName$"!");
    }
  else if (P.Credits < 100)
   {
    P.ClientMessage("|p2Insufficient Cash.");
   }
  }
}

else if(hitActor.IsA('MSBankingATM'))
{
 if (MSBankingATM(hitActor).Bank.GetAccountNum(FrobbersIP) > -1)
 {
  if (!bNegMode)
  {
  if (XMode == 0)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 1)
    {
    P.Credits -= 1;
    MSBankingATM(hitActor).Bank.AddAccountBalance(FrobbersIP, 1);
    P.ClientMessage("|p4Your ATM Balance is now "$MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP)$", "$WalletColor$""$P.Credits$" on hand.");
    }
  else if (P.Credits < 1)
   {
    P.ClientMessage("|p2You do not have enough money to deposit!");
   }
  }
  if (XMode == 1)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 5)
    {
    P.Credits -= 5;
    MSBankingATM(hitActor).Bank.AddAccountBalance(FrobbersIP, 5);
    P.ClientMessage("|p4Your ATM Balance is now "$MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP)$", "$WalletColor$""$P.Credits$" on hand.");
    }
  else if (P.Credits < 5)
   {
    P.ClientMessage("|p2You do not have enough money to deposit!");
   }
  }
  if (XMode == 2)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 10)
    {
    P.Credits -= 10;
    MSBankingATM(hitActor).Bank.AddAccountBalance(FrobbersIP, 10);
    P.ClientMessage("|p4Your ATM Balance is now "$MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP)$", "$WalletColor$""$P.Credits$" on hand.");
    }
  else if (P.Credits < 10)
   {
    P.ClientMessage("|p2You do not have enough money to deposit!");
   }
  }
  if (XMode == 3)
  {
  P = DeusExPlayer(Owner);
  if (P.Credits >= 100)
    {
    P.Credits -= 100;
    MSBankingATM(hitActor).Bank.AddAccountBalance(FrobbersIP, 100);
    P.ClientMessage("|p4Your ATM Balance is now "$MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP)$", "$WalletColor$""$P.Credits$" on hand.");
    }
  else if (P.Credits < 100)
   {
    P.ClientMessage("|p2You do not have enough money to deposit!");
   }
  }
  }
  else if (bNegMode)
  {
  if (XMode == 0)
  {
  P = DeusExPlayer(Owner);
  if (MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP) >= 1)
    {
    P.Credits += 1;
    MSBankingATM(hitActor).Bank.SubAccountBalance(FrobbersIP, 1);
    P.ClientMessage("|p4Your ATM Balance is now "$MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP)$", "$WalletColor$""$P.Credits$" on hand.");
    }
  else if (MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP) < 1)
   {
    P.ClientMessage("|p2You do not have enough money to withdraw!");
   }
  }
  if (XMode == 1)
  {
  P = DeusExPlayer(Owner);
  if (MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP) >= 5)
    {
    P.Credits += 5;
    MSBankingATM(hitActor).Bank.SubAccountBalance(FrobbersIP, 5);
    P.ClientMessage("|p4Your ATM Balance is now "$MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP)$", "$WalletColor$""$P.Credits$" on hand.");
    }
  else if (MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP) < 5)
   {
    P.ClientMessage("|p2You do not have enough money to withdraw!");
   }
  }
  if (XMode == 2)
  {
  P = DeusExPlayer(Owner);
  if (MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP) >= 10)
    {
    P.Credits += 10;
    MSBankingATM(hitActor).Bank.SubAccountBalance(FrobbersIP, 10);
    P.ClientMessage("|p4Your ATM Balance is now "$MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP)$", "$WalletColor$""$P.Credits$" on hand.");
    }
  else if (MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP) < 10)
   {
    P.ClientMessage("|p2You do not have enough money to withdraw!");
   }
  }
  if (XMode == 3)
  {
  P = DeusExPlayer(Owner);
  if (MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP) >= 100)
    {
    P.Credits += 100;
    MSBankingATM(hitActor).Bank.SubAccountBalance(FrobbersIP, 100);
    P.ClientMessage("|p4Your ATM Balance is now "$MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP)$", "$WalletColor$""$P.Credits$" on hand.");
    }
  else if (MSBankingATM(hitActor).Bank.GetAccountBalance(FrobbersIP) < 100)
   {
    P.ClientMessage("|p2You do not have enough money to withdraw!");
   }
  }
  }
 }
 if (MSBankingATM(hitActor).Bank.GetAccountNum(FrobbersIP) == -1)
 {
  MSBankingATM(hitActor).Bank.MakeNewAccount(FrobbersIP);
  Pawn(Owner).ClientMessage("|p4You have succesfully set up an account on the ATM!");
 }
}

}

function ReloadAmmo()
{
 local string extrastringything;
 
 bNegMode = !bNegMode;
 
 if (!bNegMode) extrastringything = "|p3adding to ";
 if (bNegMode) extrastringything = "|p2subtracting from ";
 
 Pawn(Owner).ClientMessage(""$WalletColor$"You are now "$extrastringything$"your ATM account!");
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == WalletSlot);
}

defaultproperties
{
     ItemName="|p3Nano Wallet"
     beltDescription="|p3WALLET"
     Texture=FireTexture'Effects.liquid.ambrosia_SFX'
     Skin=FireTexture'Effects.liquid.ambrosia_SFX'
     WalletSlot=0
     WalletColor="|p3"
     ReloadCount=0
     AmmoName=class'AmmoNone'
     LowAmmoWaterMark=0
     Misc1Sound=None
}
